<?php
/**
 * BLINDAGEM DEFINITIVA CONTRA MEMORY LEAK (ALONEWD)
 * Mantendo o funcionamento original intacto - CORREÇÃO DE POSICIONAMENTO
 */

if (session_status() === PHP_SESSION_ACTIVE) {
    session_write_close(); 
}
ob_start(); 
ini_set('memory_limit', '256M'); 
gc_enable(); 

include "session.php";
// O header.php geralmente contém menus e navbars. 
// Para o player ocupar a tela toda, ele deve ser isolado.
include "header.php"; 
include "config.php";

$id = isset($_GET["id"]) ? htmlspecialchars($_GET["id"]) : "";
$slug = isset($_GET["slug"]) ? htmlspecialchars($_GET["slug"]) : "";
$ext = isset($_GET["ext"]) ? htmlspecialchars($_GET["ext"]) : "mp4";
$series_id = isset($_GET["series_id"]) ? htmlspecialchars($_GET["series_id"]) : "";
$logo_url = "img/sTREAMING (3) (1).png"; 

$content_name = "Carregando...";

function getXtreamData($endpoint, $params = []) {
    global $get_dns, $username, $password;
    $url = $get_dns . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=" . $endpoint;
    if (!empty($params)) {
        $url .= '&' . http_build_query($params);
    }
    
    $ctx = stream_context_create(['http' => [
        'timeout' => 5,
        'header' => "Accept-Encoding: gzip\r\n"
    ]]); 
    
    $response = @file_get_contents($url, false, $ctx);
    
    if ($response) {
        $data = json_decode($response, true);
        unset($response); 
        return $data;
    }
    return null;
}

if ($slug == "movie") {
    $video_url = $get_dns . "/movie/" . $username . "/" . $password . "/" . $id . "." . $ext;
    $mime_type = "video/mp4";  
    $movie_info = getXtreamData('get_vod_info', ['vod_id' => $id]);
    if ($movie_info) { $content_name = $movie_info['info']['name'] ?? "Filme"; unset($movie_info); }
} elseif ($slug == "series") {
    $video_url = $get_dns . "/series/" . $username . "/" . $password . "/" . $id . "." . $ext;
    $mime_type = "video/mp4";  
    $series_info = getXtreamData('get_series_info', ['series_id' => $series_id]);
    if ($series_info) { $content_name = $series_info['info']['name'] ?? "Série"; unset($series_info); }
}

gc_collect_cycles(); 
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title><?php echo $content_name; ?></title>
    
    <script src="https://cdn.jsdelivr.net/npm/clappr@latest/dist/clappr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/clappr-chromecast-plugin@latest/dist/clappr-chromecast-plugin.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <style>
        :root { --accent: #ff0055; --bg: #000; }
        
        html, body {
            margin: 0; padding: 0; width: 100%; height: 100%;
            background: var(--bg); font-family: 'Inter', sans-serif;
            color: #fff; 
            /* Removido o Flexbox do body para o menu do header ficar no topo */
            overflow: hidden;
        }

        .video-player-container {
            width: 100%;
            height: 100%;
            background: #000;
            /* Position fixed garante que o player fique sobreposto a qualquer menu do header */
            position: fixed;
            top: 0;
            left: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            z-index: 9999; /* Fica acima de tudo */
        }

        #player { 
            width: 100% !important; 
            height: 100% !important; 
            z-index: 1; 
        }

        .video-player-logo {
            position: absolute; top: 25px; right: 25px; width: 90px;
            z-index: 10001; opacity: 0.6; pointer-events: none;
        }

        .back_button {
            position: absolute; top: 25px; left: 25px; width: 50px; height: 50px;
            background: rgba(0,0,0,0.5); display: flex;
            align-items: center; justify-content: center; border-radius: 50%;
            text-decoration: none; color: #fff; font-size: 1.4rem; z-index: 10001;
            transition: 0.3s ease; border: 1px solid rgba(255,255,255,0.1);
            backdrop-filter: blur(10px);
        }
        .back_button:hover { background: var(--accent); transform: scale(1.1); border-color: var(--accent); }

        @media (max-width: 768px) {
            .video-player-logo { width: 65px; top: 15px; right: 15px; }
            .back_button { top: 15px; left: 15px; width: 42px; height: 42px; font-size: 1.2rem; }
        }

        .clappr-watermark { display: none !important; }
    </style>
</head>
<body>

    <div class="video-player-container">
        <a class="back_button" href="<?php echo ($slug == 'movie') ? 'Movie_description.php?id='.$id : 'seriesvideo.php?id='.$series_id; ?>">
            <i class="fa fa-arrow-left"></i>
        </a>
        <img src="<?php echo $logo_url; ?>" class="video-player-logo" alt="Logo">
        <div id="player"></div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var player = new Clappr.Player({
                source: "<?php echo $video_url; ?>",
                mimeType: "<?php echo $mime_type; ?>",
                parentId: "#player",
                autoPlay: true,
                width: '100%',
                height: '100%',
                preload: 'auto',
                recycleVideo: true,
                plugins: [ChromecastPlugin],
                mediacontrol: {seekbar: "var(--accent)", buttons: "#fff"},
                playback: {
                    playInline: true,
                    hlsjsConfig: {
                        enableWorker: true,
                        lowLatencyMode: true,
                    }
                }
            });

            window.addEventListener('resize', function() {
                player.resize();
            });

            window.addEventListener('beforeunload', function() {
                if(player) {
                    player.stop();
                    player.destroy();
                    player = null;
                }
            });
        });
    </script>
</body>
</html>
<?php ob_end_flush(); ?>